/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.player;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.player.ClientPlayerTickEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.notifications.NotificationType;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.settings.ModeSetting;
import Krasnodar.rockstarnew.systems.setting.settings.SliderSetting;
import Krasnodar.rockstarnew.utility.inventory.InventoryUtility;
import Krasnodar.rockstarnew.utility.time.Timer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1708;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2595;
import net.minecraft.class_3965;
import net.minecraft.class_472;
import net.minecraft.class_6880;
import net.minecraft.class_9334;

@ModuleInfo(name="Auto Brew", category=ModuleCategory.PLAYER, desc="\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u0438 \u0432\u0430\u0440\u0438\u0442 \u0437\u0435\u043b\u044c\u044f")
public class AutoBrew
extends BaseModule {
    private final ModeSetting potions = new ModeSetting(this, "\u0412\u0430\u0440\u0438\u0442\u044c");
    private final ModeSetting.Value strength = new ModeSetting.Value(this.potions, "\u0417\u0435\u043b\u044c\u0435 \u0441\u0438\u043b\u044b").select();
    private final ModeSetting.Value speed = new ModeSetting.Value(this.potions, "\u0417\u0435\u043b\u044c\u0435 \u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438");
    private final ModeSetting.Value fire = new ModeSetting.Value(this.potions, "\u0417\u0435\u043b\u044c\u0435 \u043e\u0433\u043d\u0435\u0441\u0442\u043e\u0439\u043a\u043e\u0441\u0442\u0438");
    private final SliderSetting delay = new SliderSetting((SettingsContainer)this, "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430", "\u0417\u0430\u0434\u0435\u0440\u0436\u043a\u0430 \u043d\u0430 \u043f\u0435\u0440\u0435\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u0438\u043d\u0433\u0440\u0435\u0434\u0438\u0435\u043d\u0442\u043e\u0432").step(10.0f).min(100.0f).max(1000.0f).currentValue(100.0f);
    private final Timer timer = new Timer();
    private State state = State.IDLE;
    private final Timer actionTimer = new Timer();
    private class_2589 currentBrewer;
    private class_2595 currentChest;
    private final List<class_2338> processedBrewers = new ArrayList<class_2338>();
    private List<class_2589> brewersQueue = new ArrayList<class_2589>();
    private final EventListener<ClientPlayerTickEvent> onClientPlayerTickEvent = event -> {
        switch (this.state.ordinal()) {
            case 0: {
                this.handleIdleState();
                break;
            }
            case 1: {
                this.handleOpeningState();
                break;
            }
            case 2: {
                this.handleProcessingState();
                break;
            }
            case 3: {
                this.handleDepositingState();
                break;
            }
            case 4: {
                this.handleClosingState();
            }
        }
    };

    private void handleOpeningState() {
        if (AutoBrew.mc.field_1755 instanceof class_472) {
            this.state = State.PROCESSING;
        } else if (this.actionTimer.finished(500L)) {
            class_2338 pos = this.currentBrewer.method_11016();
            class_243 vec = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            class_3965 hit = new class_3965(vec, class_2350.field_11036, pos, false);
            AutoBrew.mc.field_1761.method_2896(AutoBrew.mc.field_1724, class_1268.field_5808, hit);
            this.actionTimer.reset();
        }
    }

    private void handleProcessingState() {
        class_1703 class_17032 = AutoBrew.mc.field_1724.field_7512;
        if (!(class_17032 instanceof class_1708)) {
            this.state = State.IDLE;
        } else {
            class_1708 brew = (class_1708)class_17032;
            if (brew.method_17377() <= 0 || brew.method_7611(3).method_7677().method_7909() == class_1802.field_8162) {
                if (brew.method_7611(4).method_7677().method_7909() == class_1802.field_8162 && brew.method_17377() == 0) {
                    if (this.findIngredient(class_1802.field_8183) == -1) {
                        return;
                    }
                    this.swapOneItem(class_1802.field_8183, 4);
                }
                for (int i = 0; i < 3; ++i) {
                    if (brew.method_7611(i).method_7677().method_7909() != class_1802.field_8162) continue;
                    if (this.findWaterBottle(brew) == -1) {
                        return;
                    }
                    InventoryUtility.quickMove(this.findWaterBottle(brew));
                }
                if (brew.method_7611(3).method_7677().method_7909() == class_1802.field_8162) {
                    if (this.isPotionType(brew, (class_1842)class_1847.field_8991.comp_349())) {
                        if (this.findIngredient(class_1802.field_8790) == -1) {
                            Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.ERROR, "\u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "\u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u043c\u0435\u0442\u044c " + class_1802.field_8790.method_63680().getString() + " \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435");
                        }
                        this.handleIngredient(class_1802.field_8790, 3);
                    }
                    if (this.strength.isSelected() && this.isPotionType(brew, (class_1842)class_1847.field_8999.comp_349())) {
                        this.handleIngredient(class_1802.field_8183, 3);
                    } else if (this.speed.isSelected() && this.isPotionType(brew, (class_1842)class_1847.field_8999.comp_349())) {
                        this.handleIngredient(class_1802.field_8479, 3);
                    } else if (this.fire.isSelected() && this.isPotionType(brew, (class_1842)class_1847.field_8999.comp_349())) {
                        this.handleIngredient(class_1802.field_8135, 3);
                    }
                    if (this.isPotionType(brew, (class_1842)class_1847.field_8978.comp_349()) || this.isPotionType(brew, (class_1842)class_1847.field_9005.comp_349())) {
                        this.handleIngredient(class_1802.field_8601, 3);
                    }
                    if (this.isPotionType(brew, (class_1842)class_1847.field_8987.comp_349())) {
                        this.handleIngredient(class_1802.field_8725, 3);
                    }
                    if (this.isPotionType(brew, (class_1842)class_1847.field_8993.comp_349()) || this.isPotionType(brew, (class_1842)class_1847.field_8966.comp_349()) || this.isPotionType(brew, (class_1842)class_1847.field_8969.comp_349())) {
                        this.lootPotions(brew);
                        this.state = State.DEPOSITING;
                    }
                }
            }
        }
    }

    private void handleIdleState() {
        if (this.actionTimer.finished(1000L)) {
            if (this.brewersQueue.isEmpty()) {
                this.brewersQueue = this.findBrewers();
            }
            if (!this.brewersQueue.isEmpty()) {
                this.currentBrewer = this.brewersQueue.removeFirst();
                this.state = State.OPENING_BREWER;
                this.actionTimer.reset();
            }
        }
    }

    private void handleIngredient(class_1792 item, int slot) {
        if (this.findIngredient(item) == -1) {
            Rockstar.getInstance().getNotificationManager().addNotificationOther(NotificationType.ERROR, "\u041f\u0440\u0435\u0434\u043c\u0435\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d", "\u0412\u0430\u043c \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u043c\u0435\u0442\u044c " + item.method_63680().getString() + " \u0432 \u0438\u043d\u0432\u0435\u043d\u0442\u0430\u0440\u0435");
            this.toggle();
        } else {
            this.swapOneItem(item, slot);
            AutoBrew.mc.field_1724.method_7346();
        }
    }

    private void handleDepositingState() {
        if (this.actionTimer.finished(500L)) {
            List<class_2595> chests = this.findChests();
            if (!chests.isEmpty()) {
                this.currentChest = chests.getFirst();
                this.depositPotions();
            }
            this.state = State.CLOSING;
            this.actionTimer.reset();
        }
    }

    private void handleClosingState() {
        if (this.actionTimer.finished(500L)) {
            AutoBrew.mc.field_1724.method_7346();
            if (this.currentBrewer != null) {
                this.processedBrewers.add(this.currentBrewer.method_11016());
            }
            this.state = State.IDLE;
            this.currentBrewer = null;
            this.currentChest = null;
            this.actionTimer.reset();
        }
    }

    private List<class_2589> findBrewers() {
        ArrayList<class_2589> brewers = new ArrayList<class_2589>();
        int range = 10;
        class_2338 playerPos = class_2338.method_49638((class_2374)AutoBrew.mc.field_1724.method_19538());
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 pos = playerPos.method_10069(x, y, z);
                    class_2586 class_25862 = AutoBrew.mc.field_1687.method_8321(pos);
                    if (!(class_25862 instanceof class_2589)) continue;
                    class_2589 brewer = (class_2589)class_25862;
                    brewers.add(brewer);
                }
            }
        }
        return brewers;
    }

    private List<class_2595> findChests() {
        ArrayList<class_2595> chests = new ArrayList<class_2595>();
        int range = 10;
        class_2338 playerPos = class_2338.method_49638((class_2374)AutoBrew.mc.field_1724.method_19538());
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    class_2338 pos = playerPos.method_10069(x, y, z);
                    class_2586 class_25862 = AutoBrew.mc.field_1687.method_8321(pos);
                    if (!(class_25862 instanceof class_2595)) continue;
                    class_2595 chest = (class_2595)class_25862;
                    chests.add(chest);
                }
            }
        }
        chests.sort(Comparator.comparingDouble(c -> c.method_11016().method_10262((class_2382)playerPos)));
        return chests;
    }

    private void depositPotions() {
        if (this.currentChest != null) {
            for (int i = 0; i < AutoBrew.mc.field_1724.method_31548().method_5439(); ++i) {
                int chestSlot;
                class_1799 stack = AutoBrew.mc.field_1724.method_31548().method_5438(i);
                if (!this.isPotion(stack) || (chestSlot = this.findChestSlot(this.currentChest)) == -1) continue;
                AutoBrew.mc.field_1761.method_2906(AutoBrew.mc.field_1724.field_7498.field_7763, i < 9 ? i + 36 : i, chestSlot, class_1713.field_7794, (class_1657)AutoBrew.mc.field_1724);
            }
        }
    }

    private boolean isPotion(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8574 || stack.method_7909() == class_1802.field_8436 || stack.method_7909() == class_1802.field_8150;
    }

    private int findChestSlot(class_2595 chest) {
        for (int i = 0; i < chest.method_5439(); ++i) {
            if (!chest.method_5438(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    private void lootPotions(class_1708 brew) {
        for (int i = 0; i < 3; ++i) {
            if (brew.method_7611(i).method_7677().method_7960()) continue;
            InventoryUtility.quickMove(i);
        }
    }

    private void swapOneItem(class_1792 item, int to) {
        int slot;
        if (this.timer.finished((long)(this.delay.getCurrentValue() * 2.0f)) && (slot = this.findIngredient(item)) != -1) {
            InventoryUtility.swapOneItem(slot, to);
            this.timer.reset();
        }
    }

    private int findIngredient(class_1792 item) {
        for (int i = 5; i < 41; ++i) {
            if (((class_1735)AutoBrew.mc.field_1724.field_7512.field_7761.get(i)).method_7677().method_7909() != item) continue;
            return i;
        }
        return -1;
    }

    private boolean isPotionType(class_1708 brew, class_1842 potion) {
        boolean needIng = true;
        for (int i = 0; i < 3; ++i) {
            class_1799 stack = ((class_1735)brew.field_7761.get(i)).method_7677();
            if (stack.method_7909() != class_1802.field_8574 || ((class_6880)((class_1844)stack.method_57824(class_9334.field_49651)).comp_2378().get()).comp_349() == potion) continue;
            needIng = false;
        }
        return needIng;
    }

    private int findWaterBottle(class_1708 brew) {
        for (int i = 5; i < 41; ++i) {
            class_1799 stack = ((class_1735)brew.field_7761.get(i)).method_7677();
            if (stack.method_7909() != class_1802.field_8574 || !((class_1844)stack.method_57824(class_9334.field_49651)).comp_2378().isPresent() || ((class_6880)((class_1844)stack.method_57824(class_9334.field_49651)).comp_2378().get()).comp_349() != class_1847.field_8991.comp_349()) continue;
            return i;
        }
        return -1;
    }

    private static enum State {
        IDLE,
        OPENING_BREWER,
        PROCESSING,
        DEPOSITING,
        CLOSING;

    }
}

